import RPi.GPIO as GPIO
import time
from time import sleep
import os, random
from datetime import datetime

#variables:
butPressed = [True, True, True, True, True, True, True]#if button i is pressed, then butPressed[i] is False
pin = [26, 19, 13, 6, 5, 21]#GPIO pins of each button
recordBool = False#True if a record is in progress

dialogueAudioMap = "dialogueAudio"
randomAudioMap = "randomAudio"
recordMap = "recordMap"
button7GPIOPin = 20
button8GPIOPin = 16
button9GPIOPin = 12
files = ['0.wav', '1.wav', '2.wav', '3.wav', '4.wav', '5.wav', '6.wav', '7.wav', '8.wav', '9.wav']
index = 0
indexRec = 0
ledRecord = 17

# create directory dialogueAudioMap if not exists
try: os.stat(dialogueAudioMap)
except: os.mkdir(dialogueAudioMap)

# create directory recordMap if not exists
try: os.stat(recordMap)
except: os.mkdir(recordMap)

# create directory randomAudio if not exists
try: os.stat(randomAudioMap)
except: os.mkdir(randomAudioMap)

GPIO.setmode(GPIO.BCM)
GPIO.setwarnings(False)

GPIO.setup(button7GPIOPin, GPIO.IN, pull_up_down=GPIO.PUD_UP)
GPIO.setup(button8GPIOPin, GPIO.IN, pull_up_down=GPIO.PUD_UP)
GPIO.setup(button9GPIOPin, GPIO.IN, pull_up_down=GPIO.PUD_UP)
GPIO.setup(ledRecord, GPIO.OUT)

for i in range(0, 6):
    GPIO.setup(pin[i], GPIO.IN, pull_up_down=GPIO.PUD_UP)#sets Pi's internal resistors to pull-up

while True:
    if GPIO.input(button7GPIOPin) == False:#if button 8 is pressed
        previousTime = time.time()
        print("Button 7 pressed play dialogue wav sound in map {0}".format(dialogueAudioMap))
        filename = files[index]
        index = (index+1) % len(files)
        GPIO.output(ledRecord, GPIO.LOW)
        sleep(0.1)
        while GPIO.input(button7GPIOPin) == False and recordBool == False:
            if time.time() - previousTime > 3.0:#if the button is pressed for more than three seconds, then recordBool is True
                recordBool = True
        if recordBool == True:#if recordBool is True, it plays a beep sound and then records
            os.system("aplay -D plughw:CARD=1,DEV=0 beep.wav")
            path_new_wav = os.path.join(dialogueAudioMap, "{0}.wav".format(indexRec))
            indexRec += 1
            os.system("arecord {0} -D plughw:CARD=1 -f cd -d 30 &".format(path_new_wav))#records for maximum 30 seconds in file .wav, $
            while GPIO.input(button7GPIOPin) == False:
                GPIO.output(ledRecord, GPIO.HIGH)
                sleep(0.5)
                GPIO.output(ledRecord, GPIO.LOW)
                sleep(0.5)
                #time.sleep(0.1) # hold the script here until the button is released
            os.system("pkill -9 arecord")#the record is stopped when the button is let go, or after 30 seconds
            recordBool = False
        elif filename:
            path_to_wav = os.path.join(dialogueAudioMap, filename)
            print("Playing wav sound {0}".format(path_to_wav))
            os.system("aplay -D plughw:CARD=1,DEV=0 {0}".format(path_to_wav))
            GPIO.output(ledRecord, GPIO.HIGH)
            sleep(0.1)
            while GPIO.input(button7GPIOPin) == False:
                time.sleep(0.1) # hold the script here until the button is released, otherwise will play multiple dialogue sound 
    elif GPIO.input(button8GPIOPin) == False:#if button 8 is pressed
        previousTime = time.time()
        print("Button 8 pressed play random wav sound in map {0}".format(randomAudioMap))
        filename = random.choice(os.listdir(randomAudioMap))
        GPIO.output(ledRecord, GPIO.LOW)
        sleep(0.1)
        while GPIO.input(button8GPIOPin) == False and recordBool == False:
            if time.time() - previousTime > 3.0:#if the button is pressed for more than 3 seconds, then recordBool is True
                recordBool = True
        if recordBool == True:#if recordBool is True, it plays a beep sound and then records
            os.system("aplay -D plughw:CARD=1,DEV=0 beep.wav")
            path_new_wav = os.path.join(randomAudioMap, "{0}.wav".format(indexRec))
            indexRec += 1
            os.system("arecord {0} -D plughw:CARD=1 -f cd -d 30 &".format(path_new_wav))#records for maximum 30 seconds in file .wav, $
            while GPIO.input(button8GPIOPin) == False:
                GPIO.output(ledRecord, GPIO.HIGH)
                sleep(0.5)
                GPIO.output(ledRecord, GPIO.LOW)
                sleep(0.5)
                #time.sleep(0.1) # hold the script here until the button is released
            os.system("pkill -9 arecord")#the record is stopped when the button is let go, or after 30 seconds
            recordBool = False
        if filename:
            path_to_wav = os.path.join(randomAudioMap, filename)
            print("Playing wav sound {0}".format(path_to_wav))
            os.system("aplay -D plughw:CARD=1,DEV=0 {0}".format(path_to_wav))
            GPIO.output(ledRecord, GPIO.HIGH)
            sleep(0.1)
            while GPIO.input(button8GPIOPin) == False:
                time.sleep(0.1) # hold the script here until the button is released, otherwise will play multiple random sound 
    elif GPIO.input(button9GPIOPin) == False:#if button 9 is pressed
        previousTime = time.time()
        GPIO.output(ledRecord, GPIO.LOW)
        sleep(0.1)
        while GPIO.input(button9GPIOPin) == False and recordBool == False:
            if time.time() - previousTime > 0.2:#if the button is pressed for more than 0.2 second, then recordBool is True
                recordBool = True
        if recordBool == True:#if recordBool is True, it plays a beep sound and then records
            os.system("aplay -D plughw:CARD=1,DEV=0 beep.wav")
            path_new_wav = os.path.join(recordMap, "{0}.wav".format(str(datetime.now()).replace(' ', '-')))
            #print("Start Recording to file: {0}".format(path_new_wav))
            os.system("arecord {0} -D plughw:CARD=1 -f cd -d 280 &".format(path_new_wav))#records for maximum 280 seconds in file {datetime}.wav, with cd quality
            while GPIO.input(button9GPIOPin) == False:
                GPIO.output(ledRecord, GPIO.HIGH)
                sleep(0.5)
                GPIO.output(ledRecord, GPIO.LOW)
                sleep(0.5)
                #time.sleep(0.1) # hold the script here until the button is released
            os.system("pkill -9 arecord")#the record is stopped when the button is let go, or after 120 seconds
            recordBool = False
    else:
        for i in range(0, 6):
            butPressed[i] = GPIO.input(pin[i])#checks if a button is pressed
            if butPressed[i] == False:#if a button is pressed
                previousTime = time.time()
                while butPressed[i] == False and recordBool == False:
                    butPressed[i] = GPIO.input(pin[i])
                    if time.time() - previousTime > 3.0:#if the button is pressed for more than 3 seconds, then recordBool is True
                        recordBool = True
                if recordBool == True:#if recordBool is True, it plays a beep sound and then records
                    os.system("aplay -D plughw:CARD=1,DEV=0 beep.wav")
                    print("Start Recording")
                    os.system("arecord %d.wav -D plughw:CARD=1 -f cd -d 60 &" %i)#records for maximum 60 seconds in file i.wav, with cd quality
                    while butPressed[i] == False:
                        butPressed[i] = GPIO.input(pin[i])
                        GPIO.output(ledRecord, GPIO.HIGH)
                        sleep(0.5)
                        GPIO.output(ledRecord, GPIO.LOW)
                        sleep(0.5)
                    os.system("pkill -9 arecord")#the record is stopped when the button is let go, or after 60 seconds
                    recordBool = False
                else:#if recordBool is False, it plays sound i.wav
                    GPIO.output(ledRecord, GPIO.LOW)
                    sleep(0.1)
                    os.system("aplay -D plughw:CARD=1,DEV=0 %d.wav" %i)
                    print("Play recorded audio")
                    GPIO.output(ledRecord, GPIO.HIGH)
                    sleep(3)
    time.sleep(0.1)
